<?php if (!defined('PmWiki')) exit();
/**
	Unobtrusive Google Maps integration for PmWiki
	Written by Petko Yotov 2009 http://5ko.fr

	This script is POSTCARDWARE, if you like it or use it,
	you can send me a postcard. Details at
	http://galleries.accent.bg/Cookbook/Postcard

	The following text is hereby placed into the Public Domain.
	Without any warranty.
*/
$RecipeInfo['GMap']['Version'] = '20091025b';


SDVA($GMap, array(
	'JS' => '<!-- Based on http://avi.alkalay.net/2006/11/google-maps-plugin-for-wordpress.html -->
<script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=%1$s" type="text/javascript"></script>
<script src="$FarmPubDirUrl/googlemapsPlugin.js" type="text/javascript"></script>
<script type="text/javascript"><!--
	//<![CDATA[
	var PmWikiPreview = %7$d;
	MapPluginInit(
		"%2$s", // Default width for maps
		"%3$s", // Default height for maps
		%4$s,   // Use the rel attribute instead of title
		%5$d,   // nocontrols
		%6$d    // nomarker
	);

	function gmapboxload()
	{
  new MapPlugin(\'100%%\', \'515\', false, 0, 0);
	}

 function gmapbox(id,title2)
	{
  var ihtml=$(id).innerHTML;
		ihtml=ihtml.replace(\'G2Map\',\'GMap\');
		Modalbox.show(ihtml.replace(\'google2map\',\'googlemap\'), {title: title2, width:600, height:600, afterLoad: gmapboxload, autoFocusing:false});
		return false;
	}

	//]]> -->
</script>',
	'H'=> 300,
	'W'=> '100%',
	'Rel'=> 'false',
	'nocontrols'=> 0,
	'nomarker'=> 0,
	'Key'=>'*',
));


SDVA($WikiStyle, array('g2map' => array('apply' => 'list', 'class' => 'google2map')));

SDVA($WikiStyle, array('gmap' => array('apply' => 'list', 'class' => 'googlemap')));


$ROEPatterns['!http:\\/\\/maps\\.google\\.[^\\|\\s"]+!i'] = "GMapIMap(\$m[0])";


$LinkFunctions['GMap:'] = 'LinkIMap';
$IMap['GMap:'] = 'http://maps.google.com/maps?$1';
$IMapLinkFmt['GMap:'] = "<a class='gmaplink' title='googlemap;\$LinkAlt' href='\$LinkUrl' rel='nofollow'>\$LinkText</a>";

$LinkFunctions['G2Map:'] = 'LinkIMap';
$IMap['G2Map:'] = 'http://maps.google.com/maps?$1';
$IMapLinkFmt['G2Map:'] = "<a class='gmaplink' title='google2map;\$LinkAlt' href='\$LinkUrl' rel='nofollow'>\$LinkText</a>";

$LinkFunctions['GMapKML:'] = 'LinkIMap';
$IMap['GMapKML:'] = '$1';
$IMapLinkFmt['GMapKML:'] = "<a class='gmaplink' title='kml' href='\$LinkUrl' rel='nofollow'>\$LinkText</a>";

Markup_e('(:gmap:)', 'directives', '/\\(:gmap(.*?):\\)/', "GMapConf(\$m[1])");
#Markup('(:g2map:)', 'directives', '/\\(:g2map(.*?):\\)/e', "G2MapConf(PSS('$1'))");

Markup_e('GMap:', 'directives', '/\\bGMap:/', "GMapConf(\$m[0])");
Markup_e('G2Map:', 'directives', '/\\bG2Map:/', "G2MapConf(\$m[0])");

Markup_e('GMapBoxStartFull:', 'fulltext', '/GMapBoxStart:(.*?)GMapBoxEnd:/s', "GMapBoxStartFull(\$m[0])");

Markup_e('GMapBoxStart:','directives', '/\\bGMapBoxStart:(.*?)$/', "GMapBoxStart(\$m[1])");
Markup_e('GMapBoxEnd:', 'directives', '/\\bGMapBoxEnd:/', "GMapBoxEnd(\$m[0])");




							

function GMapConf($args)
{
	global $GMap, $HTMLHeaderFmt;
	$opt = ParseArgs($args);
	if(@$opt['H']>'') $GMap['H'] = $opt['H'];
	if(@$opt['W']>'') $GMap['W'] = $opt['W'];
	$preview = (@$_REQUEST['preview']>'')? 1 : 0;
	$HTMLHeaderFmt['GMap'] = sprintf($GMap['JS'], $GMap['Key'], $GMap['W'],
		$GMap['H'], $GMap['Rel'], $GMap['nocontrols'], $GMap['nomarker'], $preview);
	if($args=='GMap:') return 'GMap:';
}


function G2MapConf($args)
{
	global $GMap, $HTMLHeaderFmt;
	$opt = ParseArgs($args);
	if(@$opt['H']>'') $GMap['H'] = $opt['H'];
	if(@$opt['W']>'') $GMap['W'] = $opt['W'];
	$preview = (@$_REQUEST['preview']>'')? 1 : 0;
	$HTMLHeaderFmt['GMap'] = sprintf($GMap['JS'], $GMap['Key'], $GMap['W'],
		$GMap['H'], $GMap['Rel'], $GMap['nocontrols'], $GMap['nomarker'], $preview);
	if($args=='G2Map:') return 'G2Map:';
}



function GMapIMap($x)
{
	$u = parse_url($x);parse_str($u['query']);
	$a = explode(' ', 'll z t om msid icolor'); $r = "GMap:";
	if(isset($sll) && !isset($ll) ) $ll = $sll;
	foreach($a as $k=>$v) if($$v>'') $r.="$v={$$v}&";
	return substr($r, 0, -1);
}


SDVA($GMapini, array(
  'LbJS' => '<script type="text/javascript" src="%1$s/prototype.js"></script>
<script type="text/javascript" src="%1$s/builder.js"></script>
<script type="text/javascript" src="%1$s/effects.js"></script>
<script type="text/javascript" src="%1$s/lightbox.js"></script>
<link rel="stylesheet" href="%1$s/lightbox.css" type="text/css" media="screen"/>',
  'LbUrl' => '$FarmPubDirUrl/lb'
));



function gmapjstring($s)
{
	$s=str_replace("'", "\'", $s);
 $s=str_replace("&#39;", "\'", $s);
	$s=str_replace('"', '\\x22', $s);
 $s=str_replace("&#34;", "\\x22", $s);
// $s=str_replace('"', "'+String.fromCharCode(34)+'",$s); 
 return($s);
}


function gmaptextstring($s)
{
	return(htmlspecialchars($s));
}


function gmapattributestring($s)
{
	$s=str_replace('"','&quot;',$s);
 return($s);
}



$GMapBoxN=1;

function GMapBoxStart($args)
{
 global $HTMLHeaderFmt;
	global $FarmPubDirUrl; 
	global $GMapBoxN;
	global $GMapini;


 $defaults = array('title'=>'Wiki map', 'text'=>' Click for map', 'caption'=>'Click for map', 'icon'=>1);
 $opts = array_merge($defaults, ParseArgs(($args)));

	if(trim($opts['caption'])==trim($opts['text'])) $opts['caption']=$opts['title'];

 if(!isset($HTMLHeaderFmt['lightbox'])) $HTMLHeaderFmt['lightbox'] = sprintf($GMapini['LbJS'], $GMapini['LbUrl']);

 $HTMLHeaderFmt['GMapBox'] = 
 '<script type="text/javascript" src="$FarmPubDirUrl/modalbox/modalbox.js"> </script>
  <link rel="stylesheet" href="$FarmPubDirUrl/modalbox/modalbox.css" type="text/css" media="screen" />';

	$result='<a href="" title="'.gmapattributestring($opts['caption']).'" onclick="return(gmapbox(\'gmapbox';
	$result.=$GMapBoxN;
	$result.='\', \''.gmapjstring($opts['title']).'\'));">';

	if($opts['icon'])
	{
	 $result.='<img src="';
	 $result.="$FarmPubDirUrl/world.gif";
		$result.='" alt="'.gmapattributestring($opts['caption']).'" ';
	 $result.=' />';
	}
	
	$result.=gmaptextstring($opts['text']).'</a>';
	$result.='<script type="text/html" id="gmapbox';
	$result.=$GMapBoxN;
	$result.='" >';

 $GMapBoxN++;

 return(keep($result));
}


function GMapBoxEnd($args)
{
 return(keep("</script>"));
}


function GMapBoxStartFull($args)
{
 $args=str_replace("GMap:","G2Map:",$args);
 $args=str_replace("%gmap%","%g2map%",$args);
 return($args);
}

