<?php if (!defined('PmWiki')) exit();
/*  Copyright (C) 2004 Patrick R. Michaud <pmichaud@pobox.com>
    Copyright (C) 2006 Christoph Sommer <http://www.deltadevelopment.de/users/christoph/>

    This file is distributed under the terms of the GNU General Public 
    License as published by the Free Software Foundation; either 
    version 2 of the License, or (at your option) any later version.  

    This module enables embedding of Scaleable Vector Grafics (.svg) files into
    wiki pages.  

    To use this module, simply place this file in the cookbook/ directory
    and add the following line into config.php:

        include_once('cookbook/svg.php');

    You can then embed SVG files into a wiki file by adding lines following
    these examples:

    %width=700 height=300% http://www.example.com/dir/test.svg
    %width=700 height=300% Attach:test.svg
    %width=700 height=300% Attach:test.svg"Alternate Content"
    %width=700 height=300% Attach:test.svg"Attach:test.gif"

*/

// Public recipe information
$RecipeInfo['Svg']['Version'] = '2006-11-22';

// Allow uploading of files ending in .svg or .svgz
$UploadExts['svg'] = 'image/svg+xml';
$UploadExts['svgz'] = 'image/svg+xml';

// Define replacements for SVG ressources
/*
Markup('svg', '<urllink', 
  "/\\b(?>(\\L))([^\\s$UrlExcludeChars]+\\.svgz?)(\"([^\"]*)\")?/e",
  "Keep(\$GLOBALS['LinkFunctions']['$1'](\$pagename,'$1','$2',NULL,'$1$2',
  '<object type=\'image/svg+xml\' data=\'\$LinkUrl\'> <param name=\'src\' value=\'\$LinkUrl\'>'), 'L').'$4'.Keep('</object>')");
*/  
  
Markup_e('svg', '<urllink', 
  "/\\b(?>(\\L))([^\\s$UrlExcludeChars]+\\.svgz?)(\"([^\"]*)\")?/",
  "Keep(\$GLOBALS['LinkFunctions'][\$m[1]](\$pagename,\$m[1],\$m[2],NULL,\$m[1].\$m[2],
  '<object type=\'image/svg+xml\' data=\'\$LinkUrl\'> <param name=\'src\' value=\'\$LinkUrl\'>'), 'L').\$m[4].Keep('</object>')");  
  

?>