<?php if (!defined('PmWiki')) exit();

//$EnableDiag = 1;

##  $WikiTitle is the name that appears in the browser's title bar.
$WikiTitle = 'Pacific Bulb Society';

## $ScriptUrl is your preferred URL for accessing wiki pages
## $PubDirUrl is the URL for the pub directory.
## (detected automatically with mosts setups)
# $ScriptUrl = 'http://www.mydomain.com/path/to/pmwiki.php';
# $PubDirUrl = 'http://www.mydomain.com/path/to/pub';

## $PageLogoUrl is the URL for a logo image
$PageLogoUrl = $PubDirUrl.'/../../pbslogo1.png';

## If you want to have a custom skin, then set $Skin to the name
## of the directory (in pub/skins/) that contains your skin files.
## See PmWiki.Skins and Cookbook.Skins.
$Skin = 'pbs_greenish';
if($pagename=="LiliumM") $Skin='mobile';

## The unique PHP session name
session_name('PBSwikiSESS');


## Allow underscore in page name DJP 2012-03-01
## must appear before any page name functions called
$PageNameChars='-[:alnum:]_\\x80-\\xfe';

function AsSpacedUS($text) {
  return AsSpacedUTF8(str_replace('_',' ',$text));
}

function MakePageNameUS($basepage, $str)
{
 global $MakePageNameFunction;

 $page=$str;

 if($MakePageNameFunction)
 {
  $MakePageNameFunction='';

  $page=MakePageName($basepage,$str);
  if(!PageExists($page))
  {
   $page2=MakePageName($basepage,str_replace(' ','_',$str));
   if(PageExists($page2)) $page=$page2;
  }

  $MakePageNameFunction = 'MakePageNameUS';
 }
 return($page);
}

$AsSpacedFunction = 'AsSpacedUS'; // has to be set up after UTF8 below
$MakePageNameFunction = 'MakePageNameUS'; 



## Passwords for the three actions: admin, edit, upload
$DefaultPasswords['admin'] = 'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX';
$DefaultPasswords['edit'] = 'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX';

## Prolong session password timeout DJP 2009/6/3
ini_set('session.gc_maxlifetime',60*60*6);
ini_set('session.gc_probability',1);
ini_set('session.gc_divisor',10);
ini_set('session.save_path',"'0;0777;./pbs_sessions");


## Uploading requires the same authentication level as editing
$HandleAuth['upload'] = 'edit';
$HandleAuth['diff'] = 'edit';

## User profile pages are in the followin group
$AuthorGroup = 'Main';

## require authors to provide a name
$EnablePostAuthorRequired = 1;

## IDENTITY-BASED AUTHORIZATION
## =============================
## AuthUser (real logins with separate usernames and passwords) is activated here.
## Go to the local page SiteAdmin.AuthUser to see some comments on and 
## administer the users of your wiki.
## More information here: http://pmwiki.org/wiki/PmWiki/AuthUser
#include_once("$FarmD/scripts/authuser.php");

## Users in the group @admins are the administrators of the wiki (can do any action)
## Logged in users can upload files and edit unprotected pages (by default, protected  
## pages are Site.* and SiteAdmin.*).
#$DefaultPasswords['admin'] = '@admins';
#$DefaultPasswords['edit'] = 'id:*';

## This makes the author name equal the login name
#$Author = $AuthId;
## ====================================

##  PmWiki comes with graphical user interface buttons for editing;
##  to enable these buttons, set $EnableGUIButtons to 1.  
$EnableGUIButtons = 1;

##  If you want uploads enabled on your system, set $EnableUpload=1.
##  You'll also need to set a default upload password, or else set
##  passwords on individual groups and pages.  For more information
##  see PmWiki.UploadsAdmin.
$EnableUpload = 1;

## Uploading happens to this directory
$UploadDir = 'files';

## Turn off all upload extensions
$UploadMaxSize = 0;

## recommended as of  2.2.46 DJP 2013-1-13
$UploadPermAdd = 0;

## Enable only these file types for uploading
$upsize=102400; // 100 K file size limitation
$UploadExtSize['jpg' ] = 10*1024*1024;
$UploadExtSize['gif' ] = $upsize;
$UploadExtSize['png' ] = $upsize;
$UploadExtSize['pdf' ] = 358400; # 350 K
$UploadExtSize['svg' ] = $upsize;

## If you want to disable overwiting of uploads, set this to 0
$EnableUploadOverwrite = 0;

## If you want to keep old versions of the same files, set this to 1 (no need 
## for this with $EnableUploadOverwrite set to 0)
# $EnableUploadVersions = 1;

## The name of every uploaded file determines where it will go in $UploadDir. 
## If the name starts with a-z letters, all these letters up to the first
## non-letter character will be used to check if a directory with such a name 
## exists under $UploadDir/. If the directory will be found, the uploaded file 
## will land in it, otherwise it will go under $UploadDir/$MyUploadPrefix/. 
## This is controlled by the custom function FmtUploadPrefixByName down below.
$MyUploadPrefix = '/00_others';


## DJP 2009-11-21, revised 2010-03-15
## auto capitalise first character of upload file names
## pmwiki 2.2.6 and later
## all but the last line below are defaults copied from MakeUploadName() in scripts/upload.php
## this file is loaded before upload.php

$UploadNameChars = "-\\w. "; # only allow a-z, 0-9, dash, space and dot 

/*
$MakeUploadNamePatterns = array( 
    "/[^$UploadNameChars]/" => '',              # strip all not-allowed characters
    '/\\.[^.]*$/e' => 'strtolower("$0")',       # convert extension to lowercase
    '/^[^[:alnum:]_]+/' => '',                  # strip initial spaces, dashes, dots
    '/[^[:alnum:]_]+$/' => '',                  # strip trailing spaces, dashes, dots
    '/^(?!th\d+---)./e' => 'strtoupper("$0")'   # auto capitalise first char of file name. Changed 2010-03-15 to skip thumbnails
);
*/


$MakeUploadNamePatterns = array( 
    "/[^$UploadNameChars]/" => '',              # strip all not-allowed characters
    '/\\.[^.]*$/' => PCCF('return strtolower($m[0]);'),# convert extension to lowercase
    '/^[^[:alnum:]_]+/' => '',                  # strip initial spaces, dashes, dots
    '/[^[:alnum:]_]+$/' => '',                  # strip trailing spaces, dashes, dots
    '/^(?!th\d+---)./' => PCCF('return strtoupper($m[0]);')   # auto capitalise first char of file name. Changed 2010-03-15 to skip thumbnails
);



##  By default, PmWiki doesn't allow browsers to cache pages.  Setting
##  $EnableIMSCaching=1; will re-enable browser caches in a somewhat
##  smart manner.  Note that you may want to have caching disabled while
##  adjusting configuration files or layout templates.
# $EnableIMSCaching = 1;                   # allow browser caching 

# Set the timezone
putenv("TZ=America/Los_Angeles");
date_default_timezone_set('America/Los_Angeles');

/* =======================
 * Advanced config options
 * ======================= */

## Enable UTF-8 (Unicode) support
# * it is better to leave it alone after instalation
# * must come before any pagename resolution
include_once($FarmD.'/scripts/xlpage-utf-8.php');
$AsSpacedFunction = 'AsSpacedUS'; // underscore names set up above

## pmwiki.php/Group/PageName instead of pmwiki.php?n=Group.PageName
$EnablePathInfo = 1;
## Open pages from the 'Main' group if the group is not specified
$pagename = MakePageName("$DefaultGroup.$DefaultName", $pagename);
## Do not show the group 'Main' in the URL
$FmtPV['$PageUrl'] = 'PUE(($group==$GLOBALS["DefaultGroup"]) ? "$ScriptUrl/$name" : "$ScriptUrl/$group/$name")';

## Limit all searches to Main group
$SearchPatterns['default'][] = '/^Main\\./';

##  Some sites may want leading spaces on markup lines to indicate
##  "preformatted text blocks", set $EnableWSPre=1 if you want to do
##  this.  Setting it to a higher number increases the number of
##  space characters required on a line to count as "preformatted text".
$EnableWSPre = 0;                       # (disabled)
# $EnableWSPre = 1;                        # lines beginning with space are preformatted
# $EnableWSPre = 4;                        # lines with 4 spaces are preformatted 

## By default, viewers are prevented from seeing the existence
## of read-protected pages in search results and page listings,
## but this can be slow as PmWiki has to check the permissions
## of each page.  Setting $EnablePageListProtect to zero will
## speed things up considerably, but it will also mean that
## viewers may learn of the existence of read-protected pages.
## (It does not enable them to access the contents of the
## pages.)
$EnablePageListProtect = 0;

##  The refcount.php script enables ?action=refcount, which helps to
##  find missing and orphaned pages.  See PmWiki.RefCount.
# add $FarmD. to following line DJP 2009-03-27
if ($action == 'refcount') include_once($FarmD.'/scripts/refcount.php');


## RSS support see PmWiki/WebFeeds DJP 2009-06-18
if ($action == 'rss'  ||
    $action == 'atom' ||
    $action == 'rdf'  ||
    $action == 'dc') include_once($FarmD.'/scripts/feeds.php');

$HTMLHeaderFmt['feedlinks'] = '<link rel="alternate" type="application/rss+xml" 
  title="$WikiTitle" href="$ScriptUrl?n=Site.AllRecentChanges&amp;action=rss&amp;list=normal" />';

$FeedFmt['rss']['item']['title'] = '{$Group} / {$Title}'; 
$FeedFmt['rss']['item']['description'] = '$LastModifiedSummary'.' - '.'$LastModifiedBy';

## pintrest opt-out 2012-02-27
$HTMLHeaderFmt['pintrest'] = '<meta name="pinterest" content="nopin" />';

## favicon fix DJP 2010-12-01
$HTMLHeaderFmt['favicon'] = '<link rel="icon" href="http://www.pacificbulbsociety.org/favicon.ico" type="image/x-icon" />';

## Google analytics DJP 2010-12-01
$HTMLHeaderFmt['analytics'] = " <script type='text/javascript'>
  var _gaq = _gaq || [];
  _gaq.push(['_setAccount', 'XXXXXXXXXXXXX']);
  _gaq.push(['_trackPageview']);
  (function() {
    var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
    ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
  })();
</script>";



##  In the 2.2.0-beta series, {$var} page variables are absolute by
##  default, but a future version will make them relative.  This setting
##  sets them out as relative to begin with.  (If you're starting a new
##  site, it's probably best to leave this setting alone.)
$EnableRelativePageVars = 1;

##  By default, pages in the Category group are manually created.
##  Uncomment the following line to have blank category pages
##  automatically created whenever a link to a non-existent
##  category page is saved.  (The page is created only if
##  the author has edit permissions to the Category group.)
# $AutoCreate['/^Category\\./'] = array('ctime' => $Now); 

## Maximum number of lines to be stored in RecentChanges pages.
$RCLinesMax = 500;

## Let RecentChanges contain a link to page history
$RecentChangesFmt = array(
  '$SiteGroup.AllRecentChanges' => '* [[{$Group}.{$Name}]]  . . . [[{$Group}.{$Name}?action=diff|$CurrentTime]] $[by] $AuthorLink: [=$ChangeSummary=]',
  '$Group.RecentChanges' => '* [[{$Group}/{$Name}]]  . . . [[{$Group}.{$Name}?action=diff|$CurrentTime]] $[by] $AuthorLink: [=$ChangeSummary=]'
);


## Allow AllEdits page DJP 2009-03-25
$RecentChangesFmt['Site.AllEdits'] = '* [[{$FullName}]] (:comment ' . microtime()
  . ' :)  . . . [[{$FullName}?action=diff|$CurrentTime]] $[by] $AuthorLink: [=$ChangeSummary=]';



##
## Configuration for Cookbook recipes
##

## SVG DJP 2012-07-23
include_once("$FarmD/cookbook/svg.php");

## Simple square thumbnail and gallery generator for PmWiki.
## Markup: Mini:picture.jpg
##include_once("$FarmD/cookbook/mini.php");

# large image support DJP 2012-12-12
# changes with this are uploadsize for jpg and base--- in FmtUploadPrefixByName()

include_once("$LocalDir/../miniplus/miniplus2.php");

## Thumbnail square size in pixels
$Mini['Px'] = 120;
## JPEG Quality of the generated thumbnails (0..100)
$Mini['Quality'] = 65;
## $Mini['LbMaxH'] = 800; $Mini['LbMaxW'] = 800;
# new mini configuration DJP 2009/08/04
$Mini['thumbs'][0] = '120x120x50x50x65xffffff';

## Lightbox - display Mini images in nice slideshows (requires Javascript)
$Mini['EnableLightbox'] = 1;
$Mini['LbUrl'] = $PubDirUrl.'/lb';

# fix filename capitalisation DJP 2009/4/15
$Mini['FixFilenames'] = 1;


## Log Recent Uploads
if (@$_REQUEST['action']=='postupload')
  include_once("$FarmD/cookbook/recentuploads.php");

  

  
## Add Limit Diffs per page (which also enables inline diff)
if ($action=='diff') {
  # make inline markup diff the default
  if (!isset($_GET['source']))
    $_GET['source'] = $_REQUEST['source'] = 'y';
  # hide the "Changed lines ..." block
  if ($DiffShow['source'] == 'y' || $_REQUEST['source'] == 'y') {
    $DiffDelFmt['c']="<div style='display:none;'>";
    $DiffAddFmt['c']="</div><div class='difftype'>\$[Changed line \$DiffLines:]</div><div class='diffchange'>";
  }

  include_once("$FarmD/cookbook/limitdiffsperpage.php");
  
  unset($DiffStartFmt);
  unset($PageDiffFmt);
} 


include_once("$FarmD/cookbook/viewdiff.php");  

##PageTopStore DJP 2009-03-25

include_once("$FarmD/cookbook/pagetopstore.php");
$WikiDir = new PageTopStore( 'wiki.d/{$FullName}', 'wikitop.d/{$FullName}' );


## NotsavedWarning DJP 2009-04-26

if($action=='edit'){
  $NsPromptSum    = "Please enter a summary of your changes to this page";
  $NsPromptAuthor = "Please enter your name as author of the changes to this page";
  include_once("$FarmD/cookbook/notsaved.php");
}


## Toggle Block DJP 2011-07-25


include_once("$FarmD/cookbook/toggle.php");
$ToggleConfig['init']='hide';

$ShowBlockCount=0;

function ShowBlockStart($pagename, $args)
{
 global $ShowBlockCount;
	
 $ShowBlockCount++;

 $defaults = array('show'=>'Show more...');
 $opts = array_merge($defaults, ParseArgs(($args)));
 $show=$opts['show'];

 return("(:toggle show='$show' box$ShowBlockCount:)\n"."(:div class='hide' style='border: 1px solid #999; padding: 5px; background-color: #D3E7CA;' id='box$ShowBlockCount':)");
}


function ShowBlockEnd($pagename, $opt)
{
 return("(:divend:)");
}

/*
Markup('showblockstart', '_begin',
  '/\\(:showblockstart\\s*(.*?):\\)/ei',
  "ShowBlockStart(\$pagename, PSS('$1'))");

Markup('showblockend', '_begin',
  '/\\(:showblockend\\s*(.*?):\\)/ei',
  "ShowBlockEnd(\$pagename, PSS('$1'))");
*/


Markup_e('showblockstart', '_begin',
  '/\\(:showblockstart\\s*(.*?):\\)/i',
  "ShowBlockStart(\$pagename, \$m[1])");

Markup_e('showblockend', '_begin',
  '/\\(:showblockend\\s*(.*?):\\)/i',
  "ShowBlockEnd(\$pagename, \$m[1])");




## Extend tables DJP 2011-12-31


$FXtableCount;
$FXtableWidth;

function FXtable($m)
{

 $t=$m[1];
 $args=$m[2];

 global $FXtableCount;
 global $FXtableWidth;
 $extra='';

 if($t=='table')
 {
  $FXtableWidth=0;
  $FXtableCount=0;

  if(preg_match("/\bcwidth\s*=\s*(\d+)\b/",$args,$matches,PREG_OFFSET_CAPTURE)==1)
  {
   $FXtableWidth=$matches[1][0];
   $args=substr($args,0,$matches[0][1]).substr($args,$matches[0][1]+strlen($matches[0][0]));
  }
 }
 else
 if($FXtableWidth>0)
 {
  if($t=='tableend')
  {
   $extra=str_repeat("(:cell:)\n",$FXtableWidth-$FXtableCount);
   $FXtableWidth=0;
  }
  else
  if($t=='cell')
  {
   $FXtableCount++;
   if($FXtableCount>$FXtableWidth)
   {
    $t='cellnr';
    $FXtableCount=1;
   }
  }
		else
		if($t=='cellnr')
		{
   $FXtableCount=1;
		}
 }
 return($extra."(:".$t." ".$args.":)");
}

Markup('Xtable', '_begin',
  '/^\\(:(table|cell|cellnr|tableend)(\\s.*?)?:\\)/i',
  "FXtable");


## CaseCorrection DJP 2012-02-24

include_once("$FarmD/cookbook/casecorrect.php");


## Google maps DJP 2011-02-28

$GMap['Key'] = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";

include_once("$FarmD/cookbook/gmap.php");


## security fix - no idea if superceded

$EnablePageVarAuth = 0; # same as in 2.2.23 


## WikiShell DJP 2011-04-30



include_once("$FarmD/cookbook/toolbox.php");
include_once("$FarmD/cookbook/WikiSh.php");
if ($group == 'WikiSh')
   include_once("$FarmD/cookbook/WikiShCL.php");
include_once("$FarmD/cookbook/SecLayer.php"); // note this includes stdconfig.php
$EnableWikiShWritePage = true;
$EnableWikiShCreatePage = true;
$EnableWikiShOverwritePage = true;
if (CondAuth($pagename, "admin")) {
   slAddAuth($wshAuthPage, "*.*", "read,create,insert,overwrite,append,prepend,attr,delete");
   $EnableWikiShDeletePage = true;
   $EnableWikiShChmod = true;
} else {
   slAddAuth($wshAuthPage, "*.*", "read");
#   slAddAuth($wshAuthPage, "Test.*", "insert,overwrite,append,prepend,delete");
}

# cookbook/powertools.php is *very* helpful in the wikish environment but is optional.  
# If you decide to install it you will need to go that page and download it and install
# it as follows:
#include_once("$FarmD/cookbook/powertools.php");


## Video player DJP 2012-11-20

include_once("$FarmD/cookbook/swf-sites.php");

## fox comments DJP 2013-05-06

include_once("$LocalDir/localfox.php");



## broken image fix DJP 2012-12-03

$HTMLHeaderFmt['xloader'] = '<script type="text/javascript" src="$FarmPubDirUrl/../loader/loader.js"> </script>';

##
## End of the usual config
##

## Use //italics// and **bold** markup in addition to the default
Markup('//', 'inline', '/(?<!https:|http:|ftp:)\\/\\/(.*?)\\/\\//', '<em>$1</em>');
#Markup('**', 'inline', '/^\\*\\*(?!\\*)(? >(.+?)\\*\\*)(?!\\S)|(?<!^|\\*)\\*\\*(.+?)\\*\\*/', '<strong>$1$2</strong>');
Markup('**', 'inline', '/^\\*\\*(?!\\*)(?>(.+?)\\*\\*)|(?<!^|\\*)\\*\\*(.+?)\\*\\*/', '<strong>$1$2</strong>');

Markup('units','inline','/(^|\\s|\\(|,|\\/)([+-.]?[\\d][\\d.,-]*) ?(mm|cm|m)(?=\\s|\\.|,|\\)|\\/|$)/','$1$2&nbsp;$3');
Markup('temps','inline','/(^|\\s|\\(|,|\\/)([+-.]?[\\d][\\d.,-]*)[ \\°]*(F|C)(?=\s|\\.|,|\\)|\\/|$)/','$1$2&nbsp;&deg;$3');

## Use alternative GUI edit buttons
$GUIButtonDirUrlFmt = '$FarmPubDirUrl/MyGuiEdit'; 

## Redefine the GuiButtons.
$GUIButtons = array(
  'em'        => array(100, "//", "//", '$[Emphasized]', '$GUIButtonDirUrlFmt/italic.gif"$[Emphasized (italic)]"', '$[ak_em]')
  ,'strong'   => array(110, "**", "**", '$[Strong]', '$GUIButtonDirUrlFmt/bold.gif"$[Strong (bold)]"',   '$[ak_strong]')
  ,'pagelink' => array(200, '[[', ']]', '$[Page link]', '$GUIButtonDirUrlFmt/pagelink.gif"$[Link to internal page]"')
  ,'extlink'  => array(210, '[[', ']]', 'http:// | $[link text]', '$GUIButtonDirUrlFmt/extlink.gif"$[Link to external page]"')
  ,'image'    => array(220, 'Mini:', '%22Tooltip%22', '$[MyImage.jpg]', '$GUIButtonDirUrlFmt/image.gif"$[Insert image]"')
  ,'attach'   => array(230, 'Attach:', '', '$[file.ext]', '$GUIButtonDirUrlFmt/attach.gif"$[Attach file]"')
  ,'big'      => false
  ,'small'    => false
  ,'sup'      => false
  ,'sub'      => false
  ,'h2'       => array(400, '\\n!! ', '\\n', '$[Heading]', '$GUIButtonDirUrlFmt/h2.gif"$[Heading]"')
  ,'h3'       => array(410, '\\n!!! ', '\\n', '$[Heading]', '$GUIButtonDirUrlFmt/h3.gif"$[Heading]"')
  ,'hr'       => array(420, '\\n----\\n', '', '', '$GUIButtonDirUrlFmt/hr.gif"$[Horizontal rule]"')
  ,'center'   => array(430, '%25center%25', '', '', '$GUIButtonDirUrlFmt/center.gif"$[Center]"')
);

## No need for VarDoc
$EnableVarMarkup = 0;

## Support custom edit form and access keys per user
$EnablePrefs = 0;

## {{{ CHOOSING THE UPLOAD PREFIX BY UPLOADED FILE NAME



$FmtP['#^(.*)(\\$FmtUpPrefByName\\b)(.*)$#'] = 'FmtUploadPrefixByNameX';
$UploadPrefixFmt = $MyUploadPrefix;
$UploadFileFmt = $UploadDir.'$FmtUpPrefByName';
$LinkFunctions['Attach:'] = 'LinkUploadByName';


Markup_e('Mini:','<links',
  "/\\b([Mm]ini\\d?(?:_\\w+)?:)([^\\s\"\\|\\[\\]]+)(\"([^\"]*)\")?((?>\\[\\[\\s*(.*?)\\]\\])($SuffixPattern))? ?/",
    "Keep(LinkUploadByName(\$pagename,\$m[1],\$m[2],\$m[4],\$m[1].\$m[2],\$m[5]), 'L')");

 
    
function LinkUploadByName($pagename, $imap, $path, $alt, $txt, $fmt=NULL) {
  global $UploadPrefixFmt;
  
  $UploadPrefixFmt = FmtUploadPrefixByName($pagename, $path);

  if (ucfirst($imap)=='Mini:') $linkfu = 'LinkMini';
  else $linkfu = 'LinkUpload';

  return $linkfu($pagename, $imap, $path, $alt, $txt, $fmt);
}



function FmtUploadPrefixByName($pagename, $fmt) {
  global $UploadDir, $MyUploadPrefix;
  $upname = basename($fmt);
  if (preg_match("#^(th\d+---)?([[:alpha:]]+)[^/]+$#", $upname, $m))
    if (is_dir("$UploadDir/$m[2]"))
      $res='/'.$m[2];
  else
    $res=$MyUploadPrefix;

  #dv('fmt:', $fmt, 'res:', $res);
  return $res;
} # }}}



function FmtUploadPrefixByNameX($ma) {
  global $UploadDir, $MyUploadPrefix;
  
  $fmt=$ma[0];
  
  $upname = basename($fmt);
  if (preg_match("#^(th\d+---|base---)?([[:alpha:]]+)[^/]+$#", $upname, $m))
    if (is_dir("$UploadDir/$m[2]"))
      $res='/'.$m[2];
  else
    $res=$MyUploadPrefix;

  #dv('fmt:', $fmt, 'res:', $res);
  return $ma[1].$res.$ma[3];
} # }}}

