<?php if(!defined('PmWiki'))exit;
/**
  A mini square thumbnail generator for PmWiki
  Written by (c) Petko Yotov 2006-2010

  This script is POSTCARDWARE, if you like it or use it,
  please send me a postcard. Details at
  http://galleries.accent.bg/Cookbook/Postcard

  This text is written for PmWiki; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version. See pmwiki.php for full details
  and lack of warranty.

  This text is partly based on the ThumbList2 picture gallery
  and on the PmWiki upload.php script.

  Copyright 2006-2010 Petko Yotov http://5ko.fr
  Copyright 2004-2007 Patrick R. Michaud http://www.pmichaud.com
*/
$RecipeInfo['Mini']['Version'] = '20100413';

SDVA($Mini, array('EnableLightbox' => 0,
  'ImgFmt' => '<img class="%3$s" src="%1$s" title="%2$s" alt="%2$s" border="0" />',
  'ImgFmtSVG' => '<img class="%3$s" src="%1$s?svg=%4$sx%5$s" title="%2$s" alt="%2$s" border="0" />',
  'LinkFmt' => '<a href="%2$s" class="minilink" %3$s>%1$s</a>',
  'MiniFmt' => '%s',

  'ImTypes' => array(1=>"gif",2=>"jpeg",3=>"png",15=>"wbmp",16=>"xbm",101=>"svg"),
  'ImRx' => array("/\\.(gif|png|jpe|jpe?g|wbmp|xbm|svg)$/i", "!^th\\d+---!"),

  'LbJS' => '<script type="text/javascript" src="%1$s/prototype.js"></script>
<script type="text/javascript" src="%1$s/builder.js"></script>
<script type="text/javascript" src="%1$s/effects.js"></script>
<script type="text/javascript" src="%1$s/lightbox.js"></script>
<link rel="stylesheet" href="%1$s/lightbox.css" type="text/css" media="screen"/>',
  'LbUrl' => '$FarmPubDirUrl/lb',
  'LbRels' => array('','%s[mini]','%s[mini%d]','%s'),
  'EnableCache' => 0, 'CacheFilename' => '.%s.mini-cache.txt',
  'FixFilenames' => 0,
  'CreateFunction' => 'MiniCreate',
));
SDVA($Mini['thumbs'], array('x'=>'100x100x50x50x90xffffff'));
SDVA($Mini['FixFilenamePatterns'], array('/\\s/'=>'_', '/[^-\\w.]/'=>''));
SDVA($Mini['FNameRPat'], array("/\\.\\w{3,4}$/i"=>'', '/_+/'=>' '));
SDVA($HandleActions, array('mini'=>'HandleMini','purgethumbs'=>'HandlePurgeMini'));



Markup('(:mini:)', 'directives', '/\\(:mini (.+):\\)/', "MiniConf");


/*
Markup('Mini:','<links',
  "/\\b([Mm]ini\\d?(?:_\\w+)?:)([^\\s\"\\|\\[\\]]+)(\"([^\"]*)\")?((?>\\[\\[\\s*(.*?)\\]\\])($SuffixPattern))? ?/e",
  "Keep(LinkMini(\$pagename,'$1','$2','$4','$1$2',PSS('$5')),'L')");
Markup('(:mini:)', 'directives', '/\\(:mini (.+):\\)/e', "MiniConf(PSS('$1'))");
*/



function LinkMini($PN, $imap, $path, $alt, $txt, $new1=NULL, $listonly=0){
  global $FmtV, $UploadFileFmt, $LinkUploadCreateFmt, $UploadUrlFmt, $PCache,
    $UploadPrefixFmt, $EnableDirectDownload, $Mini, $HTMLHeaderFmt, $Charset;

 $newlink='';
 $fpresent=true;

 if($new1)
 {
  global $MarkupFrame;

  if(preg_match("/(?>\\[\\[([^|\\]]+))\\|\\s*#\\s*\\]\\]/",$new1,$m)===1)
  {
   $newlink=MakeLink($PN,($m[1]),'['.++$MarkupFrame[0]['ref'].']');
  }
  else
  if(preg_match("/(?>\\[\\[([^|\\]]*)\\|\\s*)(.*?)\\s*\\]\\]($SuffixPattern)/",$new1,$m)===1)
  {
   $newlink=MakeLink($PN,($m[1]),($m[2]),$m[3]);
  }
  else
  if(preg_match("/(?>\\[\\[\\s*(.*?)\\]\\])($SuffixPattern)/",$new1,$m)===1)
  {
   $newlink=MakeLink($PN,($m[1]),NULL,$m[2]);
  }
 }

  if(! function_exists('imagecreate'))
    return "Mini: PHP-GD image library not found. Exiting.";
  static $cnt = 0; $cnt++;

  $lb = sprintf(@$Mini['LbRels'][ $Mini['EnableLightbox'] ], 'lightbox', $cnt);
  $ptime = $PCache[$PN]['time'];

  $test_cache = ($Mini['EnableCache'] && !@$_POST['preview'] && !$listonly);
  if($test_cache){
    $cachedir = FmtPageName($UploadFileFmt, $PN);
    $cachefile =  sprintf("$cachedir/{$Mini['CacheFilename']}", $PN);
    if(!@$_GET['recache'] && !(isset($Mini['Cache'][0]) && isset($Mini['Cache'][$cnt]))){
      $Mini['Cache'][0] = 1;
      if(file_exists($cachefile) && filemtime($cachefile) >= $ptime){
        $cache = implode('', file($cachefile));
        preg_match_all("/<(Mini(\\d+))>(.*?)<\\/\\1>/", $cache, $m);
        foreach($m[2] as $i=>$x)$Mini['Cache'][$x] = $m[3][$i];
      }
    }
    if(isset($Mini['Cache'][$cnt])){
      if(strpos($Mini['Cache'][$cnt], "rel='lightbox") )
        $HTMLHeaderFmt['lightbox'] = sprintf($Mini['LbJS'], $Mini['LbUrl']);
       return $Mini['Cache'][$cnt];
    }
  }
  $cache_ok = 1;

  if (preg_match('!^(.*)/([^/]+)$!', $path, $m)) {
    $path = $m[2]; $PN = MakePageName($PN, $m[1]);
  }
  $uploadurl = FmtPageName(IsEnabled($EnableDirectDownload,1)
      ? "$UploadUrlFmt$UploadPrefixFmt/"
      : "\$PageUrl?action=download&amp;upname=",
    $PN);
  $flist = array();
  if(preg_match("/(^|,)[!-]|[\\*\\?]/", $path)){
    $uploaddir = FmtPageName($UploadFileFmt, $PN);
    if($dirp=@opendir($uploaddir)){
      while (($f=readdir($dirp))!==false)if($f{0}!='.')$flist[$f]=$f;
      closedir($dirp);
    }
    $flist = MatchNames($flist, array_merge($Mini['ImRx'], array($path)));
    natcasesort($flist);
  }

  
  foreach(explode(',', $path) as $v)$mylist[$v] = $v;
  $mylist = array_merge(preg_grep("/^[!-]|[\\*\\?]/", $mylist, PREG_GREP_INVERT), $flist);
  if(preg_match("/^(Mini)(\\d)(_\\w+)?:$/i", $imap, $m) ){
    $imap = "{$m[1]}{$m[3]}:"; $pxidx = intval($m[2]);
  }
  else $pxidx = 0;
  if(preg_match("/^Mini_(\\w+):$/i", $imap, $m) ){
    $imap = substr($imap, 0, 4).':';   $uMini = "uMini_{$m[1]}";
    if(function_exists($uMini) ) $mylist = $uMini($mylist); else return "$txt$alt";
  }

  $html = array();
  $htmlH = $htmlF = '';
  foreach($mylist as $file=>$v)
  {
    list($upname, $fpath) = MiniFixFName($PN, $v);
    $picurl = PUE("$uploadurl$upname");

    if($listonly){ $html[] = "\n$upname"; continue; }

    if(!file_exists($fpath)){
      $FmtV['$LinkText'] = $upname;
      $FmtV['$LinkUpload'] =
        FmtPageName("\$PageUrl?action=upload&amp;upname=$upname", $PN);
      $html[] = FmtPageName($LinkUploadCreateFmt, $PN);
      $fpresent=false;
      continue;
    }

    
    if(substr($upname,strlen($upname)-4)==".svg")
    {
     $isSVG=true;
     $upname=substr($upname,0,strlen($upname)-4).".jpg";
     $picurl = PUE("$uploadurl$upname");
     $fpath=substr($fpath,0,strlen($fpath)-4).".jpg";
     if(!file_exists($fpath))
     {
      $isSVG=false;
      $t=2; // jpeg
     }
     else
     {
      list($w, $h, $t) = @getimagesize($fpath, $info);
     }
    }
    else
    {
     $isSVG=false;
     list($w, $h, $t) = @getimagesize($fpath, $info);
    }

//    logfile("up $upname fp $fpath"); // filename and path+filename


    if(!isset($Mini['ImTypes'][$t])){
      $html[] =  LinkIMap($PN, "Attach:", $upname, $alt, "Attach:$upname", $fmt);
      continue;
    }

    $mupname = "th0$pxidx---$upname.jpg";
    $basename= "base---$upname";
    $mpath = FmtPageName("$UploadFileFmt/$mupname", $PN);
    $basepath=FmtPageName("$UploadFileFmt/$basename", $PN);
    $class='mini';
    if(file_exists($basepath)) $class.=' base';
    if($isSVG)  $class.=' svg';

    if(preg_match("/_PD\\d*.jpg/",$upname)) $class.=' pd';
    
    if(file_exists($mpath) && filemtime($mpath)>=filemtime($fpath))
    {
     $miniurl = PUE("$uploadurl$mupname");
     if($isSVG) $miniurl.="?svg=".$w."x".$h;
    }
    else{
      $miniurl = PUE(FmtPageName("{\$PageUrl}?action=mini&amp;idx=$pxidx&amp;upname=$upname&amp;fpath=$fpath", $PN));
      $cache_ok = 0;NoCache();
    }
    if(trim($alt) == '-') $xalt='';
    elseif($alt>'') $xalt=str_replace('"', "&quot;", $alt);
    else $xalt = preg_replace(array_keys($Mini['FNameRPat']), array_values($Mini['FNameRPat']), $v);

    if(IsEnabled($Mini['EnableHeaderFooter'], 0) && strpos($xalt, '|')!==false){
      list($htmlH, $htmlF) = explode('|', $xalt, 2);
      $xalt = trim("$htmlH $htmlF");
    }

    if($newlink!="") $xalt.=" [Shift+click to enlarge, Click to go to wiki entry]";

    $out = sprintf($Mini['ImgFmt'], $miniurl, $xalt, $class);

    if($imap == 'Mini:')
    { # links enabled
     if($newlink=="")
     {
      $rel='';
      if($lb>'')
      {
       $rel = "rel='$lb' title=\"$xalt\"";
      }
      $out = sprintf($Mini['LinkFmt'], $out, $picurl, $rel);
     }
     if($lb>'') $HTMLHeaderFmt['lightbox'] = sprintf($Mini['LbJS'], $Mini['LbUrl']);
    }
    $html[] = $out;
  }
  $html = sprintf($Mini['MiniFmt'], implode(' ', $html));

  if($htmlH) $html = "<span class='miniH'>$htmlH</span> $html";
  if($htmlF) $html .= " <span class='miniF'>$htmlF</span>";
  if($test_cache){
    if($cache_ok){
      $mode = ($cnt==1)? 'w+' : 'a+';
      mkdirp($cachedir);
      if ($handle = @fopen($cachefile, $mode)){
        @fwrite($handle, "<Mini$cnt>$html</Mini$cnt>\n");fclose($handle);
      }
    }
    elseif(file_exists($cachefile)) unlink($cachefile);
  }


 if($newlink)
 {
  if($fpresent)
  {
   preg_match("/<(.*?)>(.*)<\/a>/",$newlink,$m);
   $html="<".$m[1]."rel=lightbox[mini]>".$html."<br />".$m[2]."</a>";
  }
  else
  {
   $html=$html."<br />".$newlink;
  }
 }

 return $html;
}





/*
function MiniConf($args){
  global $Mini; $opt = ParseArgs($args);
  if(is_array(@$opt[''])) $Mini['thumbs'] = $opt['']+$Mini['thumbs'];
  for($i=0;$i<10;$i++) if(isset($opt["m$i"]) )$Mini['thumbs'][$i] = $opt["m$i"];
}
*/


function MiniConf($args){
  if(is_array($args)) $args = $args[1];
  global $Mini; $opt = ParseArgs($args);
  if(is_array(@$opt[''])) $Mini['thumbs'] = $opt['']+$Mini['thumbs'];
  for($i=0;$i<10;$i++) if(isset($opt["m$i"]) )$Mini['thumbs'][$i] = $opt["m$i"];
}


function MiniParseAttr($x,$d=null) # '100x100x50x50x90xffffff'
{
  $y = explode('x', $x);
  $y[5] = hexdec(@$y[5]);
  if($d && $d!=$x)
  {
    $d = MiniParseAttr($d);
    foreach($d as $k=>$v)
      if(!isset($y[$k])||$y[$k]=='')
        $y[$k] = $v;
  }
  ksort($y);
  return array_map('intval', $y);
}
function MiniCreate($fpath,$mpath,$W,$H,$T,$idx){
  global $Mini;
  list($w,$h,$cx,$cy,$quality,$bg) = MiniParseAttr($Mini['thumbs'][$idx],$Mini['thumbs']['x']);
  if($h==0)$h=round($w*$H/$W);
  elseif($w==0)$w=round($h*$W/$H);
  if($h*$w==0)$h=$w=100;

  list($rr, $gg, $bb) =  $bg;
  $imcopy = (function_exists('imagecopyresampled'))?'imagecopyresampled':'imagecopyresized';
  $imcreate=(function_exists('imagecreatetruecolor'))?'imagecreatetruecolor':'imagecreate';
  $fcreate = "imagecreatefrom".$Mini['ImTypes'][$T];
  $img = $fcreate($fpath);
  if (!@$img){return;}

  $nimg = $imcreate($w, $h);
  imagefill($nimg, 0, 0, imagecolorallocate($nimg, floor($bg/256/256), ($bg/256)%256, $bg%256));

  $percent = max(1, min($H/$h, $W/$w));
  $_h = round($percent*$h);
  $_w = round($percent*$w);

  $sW = min($W,$_w); #source width
  $sH = min($H,$_h);
  $sY = max(0, round(($H-$_h)*$cx/100));
  $sX = max(0, round(($W-$_w)*$cy/100));

  $tW = min($w, $W); #target width
  $tH = min($h, $H);
  $tY = max(0, round(($h-$H)/2));
  $tX = max(0, round(($w-$W)/2));

  $imcopy($nimg,$img,$tX,$tY,$sX,$sY,$tW,$tH,$sW,$sH);

  imagedestroy($img);
  if(function_exists('imageconvolution'))
    imageconvolution($nimg, array(array(-1,-1,-1),array(-1,16,-1),array(-1,-1,-1)),8,0);
  imagejpeg($nimg,$mpath,$quality);
  imagedestroy($nimg);
}
function HandlePurgeMini($PN, $auth='edit'){
  RetrieveAuthPage($PN, $auth, 1, READPAGE_CURRENT);
  global $UploadDir, $UploadPrefixFmt, $Mini;
  $udir = FmtPageName("$UploadDir$UploadPrefixFmt", $PN);
  $cachefile =  preg_quote(sprintf($Mini['CacheFilename'], $PN));
  if ($dirp = @opendir($udir)){
    while (($file=readdir($dirp)) !== false)
      if (preg_match("/^(th\\d+---|$cachefile$)/", $file))
        unlink("$udir/$file");
    closedir($dirp);
  }
  Redirect($PN, '{$PageUrl}?action=upload');
}
function MiniFixFName($PN, $x){
  global $Mini, $UploadFileFmt;
  $y = MakeUploadName($PN, $x);
  if(!$Mini['FixFilenames']) return array($y, FmtPageName("$UploadFileFmt/$y", $PN));

  $z = preg_replace(array_keys($Mini['FixFilenamePatterns']),array_values($Mini['FixFilenamePatterns']), $y);
  $zpath = FmtPageName("$UploadFileFmt/$z", $PN);
  foreach(array($x, $y) as $v){
    $path = FmtPageName("$UploadFileFmt/$v", $PN);
    if($path != $zpath && file_exists( $path ) ) @rename($path, $zpath);
  }
  return array($z, $zpath);
}
if(!function_exists('MatchNames')){function MatchNames($l,$p){return MatchPageNames($l,$p);}}



function logfile($msg)
{
 global $LocalDir;

 $logname="$LocalDir/../miniplus/logfile.txt";

 if(file_exists($logname))
 {
  $fd=fopen($logname,"ab");
  if($fd)
  {
   $str="[".date("Y/m/d H:i:s e",mktime())."] ".$msg."\n";
   fwrite($fd,$str);
   fclose($fd);
  }
 }
}



function MiniCreateImage($newpath,$oldpath,$neww,$newh,$oldw,$oldh,$angle)
{
 $result=false;

 if($angle==90 || $angle==-90)
 {
  $temp=$neww;$neww=$newh;$newh=$temp;
  $temp=$oldw;$oldw=$oldh;$oldh=$temp;
 }

 if($neww>$oldw && $newh>$oldh)
 {
  $scale=1;
  $newwidth=$oldw;
  $newheight=$oldh;
 }
 else
 if(($neww/$oldw)<($newh/$oldh))
 {
  $scale=$neww/$oldw;
  $newwidth=$neww;
  $newheight=$scale*$oldh;
 }
 else
 {
  $scale=$newh/$oldh;
  $newwidth=$scale*$oldw;
  $newheight=$newh;
 }

 $srcimg=@imagecreatefromjpeg($oldpath);

 if($srcimg)
 {
  $destimg= @imagecreatetruecolor($newwidth,$newheight);
  if($destimg)
  {
   if(@imagecopyresampled($destimg,$srcimg, 0, 0, 0, 0, $newwidth, $newheight, $oldw, $oldh))
   {
    @imagedestroy($srcimg);
    $srcimg=false;
    if($angle) $destimg = imagerotate($destimg, $angle, 0);
    $result=@imagejpeg($destimg,$newpath,75);
   }
   @imagedestroy($destimg);
  }
  if($srcimg) @imagedestroy($srcimg);
 }

 return($result);
}



function MiniCreateNew($fpath,$mpath,$W,$H,$T,$idx){
  global $Mini;
  list($w,$h,$cx,$cy,$quality,$bg) = MiniParseAttr($Mini['thumbs'][$idx],$Mini['thumbs']['x']);
  if($h==0)$h=round($w*$H/$W);
  elseif($w==0)$w=round($h*$W/$H);
  if($h*$w==0)$h=$w=100;

  list($rr, $gg, $bb) =  $bg;
  $imcopy = (function_exists('imagecopyresampled'))?'imagecopyresampled':'imagecopyresized';
  $imcreate=(function_exists('imagecreatetruecolor'))?'imagecreatetruecolor':'imagecreate';
  $fcreate = "imagecreatefrom".$Mini['ImTypes'][$T];
  $img = $fcreate($fpath);
  if (!@$img){return;}

  $nimg = $imcreate($w, $h);
  imagefill($nimg, 0, 0, imagecolorallocate($nimg, floor($bg/256/256), ($bg/256)%256, $bg%256));

  $percent = max(1, min($H/$h, $W/$w));
  $_h = round($percent*$h);
  $_w = round($percent*$w);

  $sW = min($W,$_w); #source width
  $sH = min($H,$_h);
  $sY = max(0, round(($H-$_h)*$cx/100));
  $sX = max(0, round(($W-$_w)*$cy/100));

  $tW = min($w, $W); #target width
  $tH = min($h, $H);
  $tY = max(0, round(($h-$H)/2));
  $tX = max(0, round(($w-$W)/2));

  $imcopy($nimg,$img,$tX,$tY,$sX,$sY,$tW,$tH,$sW,$sH);

  imagedestroy($img);
  if(function_exists('imageconvolution'))
    imageconvolution($nimg, array(array(-1,-1,-1),array(-1,16,-1),array(-1,-1,-1)),8,0);
  imagejpeg($nimg,$mpath,$quality);
  imagedestroy($nimg);
}


/*

 is this file .svg

 find aspect ratio, and standard width/height

 generate standard jpg


*/


function HandleSVG(&$upname,&$isSVG,&$width,&$height,$PN,$UploadFileFmt)
{
// logfile("handle SVG $upname");

 $isSVG=false;
 $fpath = FmtPageName("$UploadFileFmt/$upname", $PN);
 $svgfpath=substr($fpath,0,strlen($fpath)-4).".svg";

// logfile("svg $svgfpath fpath $fpath");

 if(file_exists($svgfpath) && !file_exists($fpath))
 {
  $isSVG=true;
  $xml = simplexml_load_file($svgfpath);
//  logfile(print_r($xml,true));

  $xmlattributes = $xml->attributes();

//  $width = (string) $xmlattributes->width; 
//  $height = (string) $xmlattributes->height;
  $vbox=$xmlattributes->viewBox;

  $vbox=$vbox[0];
  $vbox=explode(' ', $vbox);

  $svgwidth=$vbox[2];
  $svgheight=$vbox[3];

  if($svgwidth>$svgheight)
  {
   $width=640;
   $height=(640*$svgheight)/$svgwidth;
  }
  else
  {
   $width=(550*$svgwidth)/$svgheight;
   $height=550;
  }

  {
//  $command="convert -resize $width"."x"."$height ".$svgfpath." ".$fpath;
//  exec($command, $output);

   $filePath=substr($fpath,0,strlen($fpath)-4).".png";
   $command="rsvg-convert -w $width -h $height -o $filePath ".$svgfpath;
   exec($command, $output);
//   logfile("convert $command");
//   logfile(print_r($output,true));

   $image = imagecreatefrompng($filePath);
   $bg = imagecreatetruecolor(imagesx($image), imagesy($image));
   imagefill($bg, 0, 0, imagecolorallocate($bg, 255, 255, 255));
   imagealphablending($bg, TRUE);
   imagecopy($bg, $image, 0, 0, 0, 0, imagesx($image), imagesy($image));
   imagedestroy($image);
   $quality = 80; // 0 = worst / smaller file, 100 = better / bigger file 
   imagejpeg($bg, $fpath, $quality);
   ImageDestroy($bg);
   
   unlink($filePath);
  
  }
 }
}


/*
 does the file exist
   yes - is it over size
     yes - rename to base
           gen normal version
     no carry on as usual

   no - does base version exist
     yes - gen normal version
           carry on as usual
     no - fail



*/



function HandleMini($PN, $auth="read"){
  global $Mini, $WorkDir, $UploadFileFmt, $UploadDir, $UploadPrefixFmt;
  $page = RetrieveAuthPage($PN,$auth,1, READPAGE_CURRENT);# ask for pw if needed
  $Mini['Px'] = (array)$Mini['Px']; $Mini['Py'] = (array)$Mini['Py'];
  
  
//  $q = preg_replace('/\\(:mini (.+):\\)/e',  "MiniConf(PSS('$1'))", $page['text']);
  $q = preg_replace_callback('/\\(:mini (.+):\\)/',  "MiniConf", $page['text']);
 
 $idx = intval(@$_REQUEST['idx']);
  if(!isset($Mini['thumbs'][$idx])) $idx=0;

  $upname = MakeUploadName($PN, $_REQUEST['upname']);

  HandleSVG($upname,$isSVG,$width,$height,$PN,$UploadFileFmt);
//  if($isSVG) return;

  $mupname = "th0$idx---$upname.jpg";
  $basename= "base---$upname";
  $storename= date("Y-M-d(H-i-s)")."$upname";
  $storebasename=date("Y-M-d(H-i-s)").$basename;

  $fpath = FmtPageName("$UploadFileFmt/$upname", $PN);
  $mpath = FmtPageName("$UploadFileFmt/$mupname", $PN);
  $basepath = FmtPageName("$UploadFileFmt/$basename", $PN);
  $storepath ="miniplus/store/$storename";
  $storebasepath="miniplus/store/$storebasename";

// this code is never called because other code does not gen thumbnail if no image
  if(!file_exists($fpath))
  {
   if(!file_exists($basepath)) // no normal image, no base image, give up
   {
    {Abort("? file '$fpath' not found."); exit;}
   }
   else
   {  // base image but no normal image, generate normal image, carry on
    list($W, $H, $T) = @getimagesize($fpath);
    if($T==2)
    {
     if(!MiniCreateImage($fpath,$basepath,640,550,$W,$H))
     {
      {Abort("failed to create image from base $basepath"); exit;}
     }
    }
   }
  }

  if(!file_exists($mpath) || filemtime($mpath)<filemtime($fpath))
  {
   list($W, $H, $T) = @getimagesize($fpath);
   $angle=0;
   $exif = @exif_read_data($fpath);
   if(!empty($exif['Orientation']))
   {
    switch($exif['Orientation'])
    {
     case 3:
            $angle=180;
            break;

     case 6:
            $angle=-90;
            $temp=$W;$W=$H;$H=$temp;
            break;

     case 8:
            $angle=90;
            $temp=$W;$W=$H;$H=$temp;
            break;
    }
   }


   $size=filesize($fpath);
   if(!isset($Mini['ImTypes'][$T])){Abort("? format $T not supported."); exit;}
   if($T==2)
   {
    // is this oversize, rename to base, generate normal image
    if($W>1920 || $H>1280 || (($size >400*1024) && ($W>768 || $H>660)) || ($angle!=0))
    {
     // too big to be a base image, rename to store, resize

     if(rename($fpath,$storepath)) // return false on fail
     {
      if(!MiniCreateImage($fpath,$storepath,1920,1280,$W,$H,$angle))
      {
       {Abort("failed to create image from store $storepath"); exit;}
      }
      list($W, $H, $T) = @getimagesize($fpath);
      $size=filesize($fpath);
      $angle=0;
     }
     else
     {
      {Abort("failed to rename to $storepath"); exit;}
     }
    }

    if($W>768 || $H>660) // big enough to justify a base image
    {
     if(file_exists($basepath)) // shift old base image out of way
     {
      if(!rename($basepath,$storebasepath))
      {
       {Abort("failed to rename to $storebasepath"); exit;}
      }
     }

     if(rename($fpath,$basepath)) // return false on fail
     {
      if(!MiniCreateImage($fpath,$basepath,640,550,$W,$H,$angle))
      {
       {Abort("failed to create image from base $basepath"); exit;}
      } 
      list($W, $H, $T) = @getimagesize($fpath);
      $angle=0;
     }
     else
     {
      {Abort("failed to rename to $basepath"); exit;}
     }
    }
    else
    if(($angle!=0) || $W>640 || $H>550 || ($size>200*1024))
    {
     if(rename($fpath,$storepath)) // return false on fail
     {
      if(!MiniCreateImage($fpath,$storepath,640,550,$W,$H,$angle))
      {
       {Abort("failed to create image from store $storepath"); exit;}
      }
      list($W, $H, $T) = @getimagesize($fpath);
      $angle=0;
     }
     else
     {
      {Abort("failed to rename to $storepath"); exit;}
     }
    }
   }

   MiniCreateNew($fpath,$mpath,$W,$H,$T,$idx);
  }
  $_REQUEST['upname'] = $mupname;
  HandleDownload($PN);
}


if($action=="demo")
{

  $Mini['LbJS']='<script type="text/javascript" src="$PubDirUrl/../miniplus/jquery-1.8.3.js"></script>
<script type="text/javascript" `"$PubDirUrl/../miniplus/lightbox.js"></script>
<link rel="stylesheet" href="$PubDirUrl/../miniplus/lightbox.css" type="text/css" media="screen"/>';


}


